const blocks = (extFacePanels) => ([{
        "opcode": "BLOCK_1686417129070",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "izquierdo": {
                "type": "number",
                "defaultValue": 2
            },
            "derecho": {
                "type": "number",
                "defaultValue": 3
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `  servo_/*{izquierdo}*/.attach(/*{izquierdo}*/);\r\n  servo_/*{derecho}*/.attach(/*{derecho}*/);`,
                "sections": {
                    "include": [
                        "<Servo.h>"
                    ],
                    "lib": `Servo servo_/*{izquierdo}*/;\r\nServo servo_/*{derecho}*/;\r\nint vel;`
                }
            }
        },
        "handler": this.funcs.BLOCK_1686417129070
    },
    {
        "opcode": "BLOCK_1686414751325",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "elegido": {
                "type": "fieldMenu",
                "defaultValue": "2",
                "menu": "BLOCK_1686414751325_ELEGIDO"
            },
            "velocidad": {
                "type": "number",
                "defaultValue": 0
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `vel=0;\r\nif (/*{velocidad}*/ > 85)\r\n    vel = 85;\r\nelse if (/*{velocidad}*/ < -85)\r\n    vel = -85;\r\nelse \r\n    vel = /*{velocidad}*/;\r\n\r\n\r\nif (/*{elegido}*/ == 2)\r\n{\r\n    servo_/*{elegido}*/.write(90 + vel);\r\n} else {\r\n    servo_/*{elegido}*/.write(90 - vel);\r\n}`
            }
        },
        "handler": this.funcs.BLOCK_1686414751325
    },
    {
        "opcode": "BLOCK_1686493619981",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "direccion": {
                "type": "fieldMenu",
                "defaultValue": " 1",
                "menu": "BLOCK_1686493619981_DIRECCION"
            },
            "velocidad": {
                "type": "number",
                "defaultValue": 45
            },
            "tiempo": {
                "type": "number",
                "defaultValue": 1
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `vel=0;\r\nif (/*{velocidad}*/ > 85)\r\n    vel = 85;\r\nelse if (/*{velocidad}*/ < -85)\r\n    vel = -85;\r\nelse \r\n    vel = /*{velocidad}*/;\r\n\r\nswitch(/*{direccion}*/){\r\n\r\n    case 0: \r\n        servo_2.write(90 - 0);\r\n        servo_3.write(90 + 0);\r\n        _delay(/*{tiempo}*/);\r\n    break;\r\n    case 1: \r\n        servo_2.write(90 + vel );\r\n        servo_3.write(90 - vel );\r\n        _delay(/*{tiempo}*/);\r\n    break;\r\n    case 2: \r\n        servo_2.write(90 - vel );\r\n        servo_3.write(90 + vel );\r\n        _delay(/*{tiempo}*/);\r\n    break;\r\n    case 3: \r\n        servo_2.write(90 - vel );\r\n        servo_3.write(90 - vel );\r\n        _delay(/*{tiempo}*/);\r\n    break;\r\n    case 4: \r\n        servo_2.write(90 + vel );\r\n        servo_3.write(90 + vel );\r\n        _delay(/*{tiempo}*/);\r\n    break;\r\n\r\n}\r`
            }
        },
        "handler": this.funcs.BLOCK_1686493619981
    },
    {
        "opcode": "BLOCK_1686455479945",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "sonido": {
                "type": "fieldMenu",
                "defaultValue": "0",
                "menu": "BLOCK_1686455479945_SONIDO"
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `       sing(/*{sonido}*/);\r`,
                "sections": {
                    "include": [
                        "\"src/Otto_sounds.h\""
                    ],
                    "lib": `\r\nvoid _tone (float noteFrequency, long noteDuration, int silentDuration){\r\n\r\n    // tone(10,261,500);\r\n    // delay(500);\r\n\r\n      if(silentDuration==0){silentDuration=1;}\r\n\r\n      tone(13, noteFrequency, noteDuration);\r\n      delay(noteDuration);       //milliseconds to microseconds\r\n      //noTone(PIN_Buzzer);\r\n      delay(silentDuration);\r\n}\r\n\r\n\r\nvoid sing(int songName){\r\n  switch(songName){\r\n\r\n    case S_connection:\r\n      _tone(note_E5,50,30);\r\n      _tone(note_E6,55,25);\r\n      _tone(note_A6,60,10);\r\n    break;\r\n\r\n    case S_disconnection:\r\n      _tone(note_E5,50,30);\r\n      _tone(note_A6,55,25);\r\n      _tone(note_E6,50,10);\r\n    break;\r\n\r\n    case S_buttonPushed:\r\n      bendTones (note_E6, note_G6, 1.03, 20, 2);\r\n      delay(30);\r\n      bendTones (note_E6, note_D7, 1.04, 10, 2);\r\n    break;\r\n\r\n    case S_mode1:\r\n      bendTones (note_E6, note_A6, 1.02, 30, 10);  //1318.51 to 1760\r\n    break;\r\n\r\n    case S_mode2:\r\n      bendTones (note_G6, note_D7, 1.03, 30, 10);  //1567.98 to 2349.32\r\n    break;\r\n\r\n    case S_mode3:\r\n      _tone(note_E6,50,100); //D6\r\n      _tone(note_G6,50,80);  //E6\r\n      _tone(note_D7,300,0);  //G6\r\n    break;\r\n\r\n    case S_surprise:\r\n      bendTones(800, 2150, 1.02, 10, 1);\r\n      bendTones(2149, 800, 1.03, 7, 1);\r\n    break;\r\n\r\n    case S_OhOoh:\r\n      bendTones(880, 2000, 1.04, 8, 3); //A5 = 880\r\n      delay(200);\r\n\r\n      for (int i=880; i<2000; i=i*1.04) {\r\n           _tone(note_B5,5,10);\r\n      }\r\n    break;\r\n\r\n    case S_OhOoh2:\r\n      bendTones(1880, 3000, 1.03, 8, 3);\r\n      delay(200);\r\n\r\n      for (int i=1880; i<3000; i=i*1.03) {\r\n          _tone(note_C6,10,10);\r\n      }\r\n    break;\r\n\r\n    case S_cuddly:\r\n      bendTones(700, 900, 1.03, 16, 4);\r\n      bendTones(899, 650, 1.01, 18, 7);\r\n    break;\r\n\r\n    case S_sleeping:\r\n      bendTones(100, 500, 1.04, 10, 10);\r\n      delay(500);\r\n      bendTones(400, 100, 1.04, 10, 1);\r\n    break;\r\n\r\n    case S_happy:\r\n      bendTones(1500, 2500, 1.05, 20, 8);\r\n      bendTones(2499, 1500, 1.05, 25, 8);\r\n    break;\r\n\r\n    case S_superHappy:\r\n      bendTones(2000, 6000, 1.05, 8, 3);\r\n      delay(50);\r\n      bendTones(5999, 2000, 1.05, 13, 2);\r\n    break;\r\n\r\n    case S_happy_short:\r\n      bendTones(1500, 2000, 1.05, 15, 8);\r\n      delay(100);\r\n      bendTones(1900, 2500, 1.05, 10, 8);\r\n    break;\r\n\r\n    case S_sad:\r\n      bendTones(880, 669, 1.02, 20, 200);\r\n    break;\r\n\r\n    case S_confused:\r\n      bendTones(1000, 1700, 1.03, 8, 2);\r\n      bendTones(1699, 500, 1.04, 8, 3);\r\n      bendTones(1000, 1700, 1.05, 9, 10);\r\n    break;\r\n\r\n    case S_fart1:\r\n      bendTones(1600, 3000, 1.02, 2, 15);\r\n    break;\r\n\r\n    case S_fart2:\r\n      bendTones(2000, 6000, 1.02, 2, 20);\r\n    break;\r\n\r\n    case S_fart3:\r\n      bendTones(1600, 4000, 1.02, 2, 20);\r\n      bendTones(4000, 3000, 1.02, 2, 20);\r\n    break;\r\n\r\n  }\r\n}\r\n\r\n\r\nvoid bendTones (float initFrequency, float finalFrequency, float prop, long noteDuration, int silentDuration){\r\n\r\n  //Examples:\r\n  //  bendTones (880, 2093, 1.02, 18, 1);\r\n  //  bendTones (note_A5, note_C7, 1.02, 18, 0);\r\n\r\n  if(silentDuration==0){silentDuration=1;}\r\n\r\n  if(initFrequency < finalFrequency)\r\n  {\r\n      for (int i=initFrequency; i<finalFrequency; i=i*prop) {\r\n          _tone(i, noteDuration, silentDuration);\r\n      }\r\n\r\n  } else{\r\n\r\n      for (int i=initFrequency; i>finalFrequency; i=i/prop) {\r\n          _tone(i, noteDuration, silentDuration);\r\n      }\r\n  }\r\n}\r\n\r`
                }
            }
        },
        "handler": this.funcs.BLOCK_1686455479945
    },
    {
        "opcode": "BLOCK_1686445768842",
        "blockType": "number",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "trig": {
                "type": "number",
                "defaultValue": 8
            },
            "echo": {
                "type": "number",
                "defaultValue": 9
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `getDistancia()`,
                "sections": {
                    "lib": `float getDistancia()\r\n{\r\n    int trig=/*{trig}*/;\r\n    int echo=/*{echo}*/;\r\n    pinMode(trig,OUTPUT);\r\n    digitalWrite(trig,LOW);\r\n    delayMicroseconds(2);\r\n    digitalWrite(trig,HIGH);\r\n    delayMicroseconds(10);\r\n    digitalWrite(trig,LOW);\r\n    pinMode(echo, INPUT);\r\n    return pulseIn(echo,HIGH,30000)/58.0;\r\n}\r\n\r`
                }
            }
        },
        "handler": this.funcs.BLOCK_1686445768842
    },
    {
        "opcode": "BLOCK_1686447348933",
        "blockType": "boolean",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {
            "puerto": {
                "type": "number",
                "defaultValue": 5
            }
        },
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": `digitalRead(/*{puerto}*/)`
            }
        },
        "handler": this.funcs.BLOCK_1686447348933
    },
    {
        "opcode": "BLOCK_1686749900706",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {},
        "branchCount": 0,
        "codes": {
            "arduinoc": {
                "code": "vel = 30;\r\n/* is sensor left  on line , stop left  motor */\r\nif (digitalRead(5) )  \r\n{\r\n    servo_2.write(90 + 0 );\r\n    servo_3.write(90 - vel );\r\n} else \r\n{\r\n    servo_2.write(90 + vel );\r\n    servo_3.write(90 - vel );\r\n}\r\n\r\n/* is sensor right on line , stop right motor */\r\nif (digitalRead(6) )  \r\n{\r\n    servo_2.write(90 + vel );\r\n    servo_3.write(90 - 0 );\r\n} else \r\n{\r\n    servo_2.write(90 + vel );\r\n    servo_3.write(90 - vel );\r\n}\r\n"
            }
        },
        "handler": this.funcs.BLOCK_1686749900706
    },
    {
        "opcode": "BLOCK_1686749934666",
        "blockType": "command",
        "checkboxInFlyout": false,
        "gap": 12,
        "arguments": {},
        "branchCount": 0,
        "handler": this.funcs.BLOCK_1686749934666
    }
]);

export default blocks;